/** @type {import("../plugins/filesaver")} */
const FileSaver = globalThis.saveAs;


function riempi (codice) {
    var codice_fiscale = codice;
    var versione = $("#versione").val();
    versione = versione.replace(".", "_");
    const outputPath = `${codice_fiscale}_Verbale_Di_Istruttoria_Liquidazione_${tipo_beneficiario}_`+versione+`.xlsx`;
    const anagrafica_data = {};

    // Sezione Anagrafica
    if (tipo_beneficiario === "associati") {
        anagrafica_data.denominazione = $("#denominazione_associati").val();
        anagrafica_data.sede_prov = $("#sede_provincia_associati").val();
        anagrafica_data.n_imprese = $("#numero_imprese_agricole_associate").val();
        anagrafica_data.codice_fiscale = $(`#codice_fiscale_${tipo_beneficiario}`).val();
    } else if (tipo_beneficiario === "singoli") {
        anagrafica_data.denominazione = $("#denominazione_singoli").val();
        anagrafica_data.ccia = $("#ccia-riferimento").val();
        anagrafica_data.rea = $("#numero-rea").val();
        anagrafica_data.inps = $("#numero-inps").val();
    } else if (tipo_beneficiario === "comuni") {
        anagrafica_data.comune_riferimento = $("#comune_riferimento").val();
        anagrafica_data.p_iva = $("#p-iva").val();
    }
    anagrafica_data.nome = $(`#nome_${tipo_beneficiario}`).val();
    anagrafica_data.cognome = $(`#cognome_${tipo_beneficiario}`).val();
    anagrafica_data.data_nascita = getFormattedDate($(`#data-nascita_${tipo_beneficiario}`).val());
    anagrafica_data.luogo_nascita = $(`#luogo-nascita_${tipo_beneficiario}`).val();
    anagrafica_data.provincia_nascita = $(`#provincia-nascita_${tipo_beneficiario}`).val();
    anagrafica_data.cuua = $(`#cuua_${tipo_beneficiario}`).val();
    anagrafica_data.residenza = $(`#residenza_${tipo_beneficiario}`).val();
    anagrafica_data.provincia = $(`#provincia_${tipo_beneficiario}`).val();
    anagrafica_data.indirizzo = $(`#indirizzo_${tipo_beneficiario}`).val();
    anagrafica_data.civico = $(`#civico_${tipo_beneficiario}`).val();
    anagrafica_data.email = $(`#email_${tipo_beneficiario}`).val();
    anagrafica_data.pec = $(`#pec_${tipo_beneficiario}`).val();
    anagrafica_data.telefono = $(`#telefono_${tipo_beneficiario}`).val();
    anagrafica_data.qualifica = $(`input[name=qualifica_${tipo_beneficiario}]:checked`).val();
    anagrafica_data.sede_leg = $(`#sede_${tipo_beneficiario}`).val();
    anagrafica_data.sede_indirizzo = $(`#sede_indirizzo_${tipo_beneficiario}`).val();
    anagrafica_data.civico_sede = $(`#civico_sede_${tipo_beneficiario}`).val();
    
    // Costruzione localizzazioni
    const totale_localizzazioni = parseInt($("#numero_localizzazioni_investimenti").val());
    anagrafica_data.provincia_localizzazione = $("#provincia-localizzazione").val();
    anagrafica_data.comune_localizzazione = $("#comune-localizzazione").val();
    anagrafica_data.foglio = $("#foglio").val();
    anagrafica_data.particella = $("#particella").val();

    for (let i = 2; i <= totale_localizzazioni; i++) {
        anagrafica_data[`provincia_localizzazione_${i}`] = $("#provincia-localizzazione").val();
        anagrafica_data[`comune_localizzazione_${i}`] = $("#comune-localizzazione_" + i).val();
        anagrafica_data[`foglio_${i}`] = $("#foglio_" + i).val();
        anagrafica_data[`particella_${i}`] = $("#particella_" + i).val();
    }
        // === DATI TECNICO INCARICATO (solo quelli principali) ===
    anagrafica_data.tecnico_nome     = $('#nome-tecnico').val() || '';
    anagrafica_data.tecnico_cognome  = $('#cognome-tecnico').val() || '';
    anagrafica_data.tecnico_email    = $('#mail-tecnico').val() || '';
    anagrafica_data.tecnico_telefono = $('#recapito-tecnico').val() || '';

    const righe_anagrafica = [ [ anagrafica_data ] ];
    genera_template(outputPath, righe_anagrafica);
}

function extract_data_by_key(rows, keys) {
    return keys.map(key => {
        return rows.map(riga => {
            const obj = riga[0];
            return obj?.[key] ?? '';
        });
    });
}

function setOtherData(sheet, sezione, columnHeader, rows, keys) {
    const data_by_field = extract_data_by_key(rows, keys);

    if (sezione !== '') {
        const rowIndex = sheet.rowCount + 1;
        sheet.mergeCells(`A${rowIndex}:B${rowIndex}`);
        const cell = sheet.getCell(rowIndex, 1);
        cell.value = sezione;
        cell.alignment = { horizontal: 'center', vertical: 'middle' };
        cell.font = { bold: true, size: 11 };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    }

    columnHeader.forEach((fieldLabel, index) => {
        const row = sheet.addRow([fieldLabel, ...data_by_field[index]]);

        row.getCell(1).font = { bold: true };
        row.eachCell((cell, i) => {
            cell.alignment = { wrapText: true, vertical: 'middle' };
            if (cell.value !== '') {
                cell.border = {
                    top: { style: 'thin' },
                    left: { style: 'thin' },
                    bottom: { style: 'thin' },
                    right: { style: 'thin' }
                };
            }
        });
    });
}


function getFormattedDate(date) {
    var date = date.split("-");
    var anno = date[0];
    var mese = date[1];
    var giorno = date[2];
    
    return giorno + '/' + mese + '/' + anno;
}

async function genera_template(outputPath, righe_anagrafica) {
    const workbook = new ExcelJS.Workbook();
    const sheet1 = workbook.addWorksheet('1_Anagrafica');
    const sheet2 = workbook.addWorksheet('2_Checklist');
    const sheet3 = workbook.addWorksheet('3_Titoli_Abilitativi');

    /* Primo worksheet */

    // Workaround bug ExcelJS per le immagini
    const imageId = workbook.addImage({
        base64: $('#png_regione_siciliana').attr('src').split(',')[1],
        extension: 'png'
    });
    sheet1.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });
    sheet1.mergeCells('A1:G4');
    sheet1.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet1.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet1.getCell('A1').font = { bold: true, size: 14 };
    sheet1.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet1.mergeCells('A5:G12');
    sheet1.getCell('A5').value = 'Interventi in conto capitale per fronteggiare la crisi idrica in agricoltura in attuazione dell’art.13 della legge regionale 4 luglio 2024, n.23. Avviso approvato con D.D.G. n. 6186 del 29/08/2024';
    sheet1.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet1.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'D9D9D9' } };
    sheet1.getCell('A5').font = { size: 14 };

    sheet1.mergeCells('A13:G16');
    sheet1.getCell('A13').value = 'Verbale di ammissibilità';
    sheet1.getCell('A13').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet1.getCell('A13').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet1.getCell('A13').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

    sheet1.columns = [
        { key: 'colA', width: 45.97 },
        { key: 'colB', width: 10.39 },
        { key: 'colC', width: 14.91 },
        { key: 'colD', width: 16.55 },
        { key: 'colE', width: 11.26 },
        { key: 'colF', width: 9.00 },
    ];


    let anagraficaHeader;
    let anagrafica_keys;

    if (tipo_beneficiario === "associati") {
        anagraficaHeader = [
            'Nome', 'Cognome', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita',
            'Codice Fiscale', 'Residenza', 'Provincia', 'Indirizzo', 'Civico', 'Pec Istituzionale',
            'Mail Istituzionale', 'Telefono/Cellulare', 'Qualifica', 
            'Denominazione', 'CUAA', 'Sede Legale', 'Provincia Sede Legale', 'Indirizzo Sede Legale', 'Civico Sede Legale', 'N. Imprese Agricole'
        ];
        anagrafica_keys = [
            "nome", "cognome", "data_nascita", "luogo_nascita", "provincia_nascita",
            "codice_fiscale", "residenza", "provincia", "indirizzo", "civico", "pec", 
            "email", "telefono", "qualifica", 
            "denominazione", "cuua", "sede_leg", "sede_prov", "sede_indirizzo", "civico_sede", "n_imprese"
        ];
    } else if (tipo_beneficiario === "singoli") {
        anagraficaHeader = [
            'Nome', 'Cognome', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita',
            'CUAA', 'Residenza', 'Provincia', 'Indirizzo', 'Civico', 'Pec Aziendale',
            'Mail Aziendale', 'Telefono/Cellulare', 'Qualifica', 'Denominazione', 'Sede Legale',
            'Indirizzo Sede Legale', 'Civico Sede Legale', 'Provincia di riferimento della CCIAA',
            'Numero REA', 'Numero iscrizione INPS'
        ];
        anagrafica_keys = [
            "nome", "cognome", "data_nascita", "luogo_nascita", "provincia_nascita",
            "cuua", "residenza", "provincia", "indirizzo", "civico", "pec", 
            "email", "telefono", "qualifica", "denominazione", "sede_leg", 
            "sede_indirizzo", "civico_sede", "ccia", "rea", "inps"
        ];
    } else if (tipo_beneficiario === "comuni") {
        anagraficaHeader = [
            'Nome', 'Cognome', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita',
            'Codice Fiscale', 'Residenza', 'Provincia', 'Indirizzo', 'Civico', 'Pec Istituzionale',
            'Mail Istituzionale', 'Telefono/Cellulare', 'Qualifica', 'Comune di Riferimento', 'Sede Legale',
            'Indirizzo Sede Legale', 'Civico Sede Legale', 'CUAA del Comune'
        ];
        anagrafica_keys = [
            "nome", "cognome", "data_nascita", "luogo_nascita", "provincia_nascita",
            "cuua", "residenza", "provincia", "indirizzo", "civico", "pec", 
            "email", "telefono", "qualifica", "comune_riferimento", "sede_leg", 
            "sede_indirizzo", "civico_sede", "p_iva"
        ];
    }
    
    setOtherData(sheet1, 'Sezione Anagrafica', anagraficaHeader, righe_anagrafica, anagrafica_keys);
    
    sheet1.addRow([]);
    sheet1.addRow([]);


    let localizzazioneHeader = [
        'Provincia di localizzazione', 'Comune di localizzazione', 'Foglio', 'Particelle'
    ];
    let localizzazione_keys = [
        "provincia_localizzazione", "comune_localizzazione", "foglio", "particella"
    ];
    setOtherData(sheet1, 'Localizzazione Investimento n.1', localizzazioneHeader, righe_anagrafica, localizzazione_keys);
    var totale_localizzazioni = $("#numero_localizzazioni_investimenti").val();
    for(let i = 2; i <= totale_localizzazioni; i++){
        localizzazione_keys = [
            `provincia_localizzazione_${i}`, `comune_localizzazione_${i}`, `foglio_${i}`, `particella_${i}`
        ];
        setOtherData(sheet1, `Localizzazione Investimento n.${i}`, localizzazioneHeader, righe_anagrafica, localizzazione_keys);
    }

    sheet1.addRow([]);
    sheet1.addRow([]);
        // === Dati Tecnico Incaricato (aggiunti sotto la sezione anagrafica) ===
    const tecnicoHeader = [
        'Nome Tecnico',
        'Cognome Tecnico',
        'Email Tecnico',
        'Telefono/Cellulare Tecnico'
    ];
    
    const tecnicoKeys = [
        'tecnico_nome',
        'tecnico_cognome',
        'tecnico_email',
        'tecnico_telefono'
    ];
    
    setOtherData(sheet1, 'Dati Tecnico Incaricato', tecnicoHeader, righe_anagrafica, tecnicoKeys);
    sheet1.addRow([]); // riga vuota di separazione
    

    
    /* Secondo worksheet */

    sheet2.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });

    sheet2.columns = [
        { key: 'cat', width: 50 },
        { key: 'n_fatt', width: 20 },
        { key: 'emitt_fatt', width: 20 },
        { key: 'imp', width: 20 },
        { key: 'imp_iva', width: 20 },
        { key: 'copia_fatt', width: 20 },
        { key: 'ric_bon', width: 20 },
        { key: 'sal_saldo', width: 20 },
        { key: 'relazione', width: 20 },
        { key: 'sal', width: 20 },
        { key: 'certificato', width: 20 },
        { key: 'note', width: 10 },
    ];
    

    sheet2.mergeCells('A1:G4');
    sheet2.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet2.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet2.getCell('A1').font = { bold: true, size: 14 };
    sheet2.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet2.mergeCells('A5:G8');
    sheet2.getCell('A5').value = 'VERBALE ISTRUTTORIA LIQUIDAZIONE';
    sheet2.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet2.getCell('A5').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet2.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

    sheet2.addRow([
        "CATEGORIA INTERVENTI",
        "N. FATTURA",
        "EMITTENTE FATTURA",
        "IMPORTO IMPONIBILE",
        "IMPORTO\nIVA INCLUSA",
        "COPIA FATTURA",
        "RICEVUTA BONIFICO",
        "SAL/SALDO",
        "RELAZIONE FINALE",
        "SAL",
        "CERTIFICATO DI\nPAGAMENTO",
        "NOTE"
    ]);
    var headerRow = sheet2.getRow(sheet2.rowCount);
    headerRow.height = 42;
    headerRow.eachCell((cell, colNumber) => {
        cell.alignment = { 
            horizontal: 'center', 
            vertical: 'middle',
            wrapText: true
        };
        cell.font = { bold: true };
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
        sheet2.getColumn(colNumber).width = sheet2.columns[colNumber - 1].width;
    });
    headerRow.commit();

    let versione = $("#versione").val();
    versione = versione.replace(".", "_");
    var righe_tabella = $("#investimenti tbody tr");
    var righe_sal_saldo = $("#tabella_sal_saldo tbody tr");
    var righe_spese = [];

    function insertAndShift(riga_saldo, arr, row_index, index, value) {
        if (riga_saldo.find(`td:eq(${row_index}) input`).attr('type') !== 'file') {
            arr.splice(index, 0, value);
            return arr[index];
        }
    }

    righe_tabella.each(function(index) {
        var id = $(this).attr("id");
        
        if (id.substring(0, 21) == "categoria_interventi_") {
            var categoria               = $(this).find("td:eq(0) select option:selected").text();
            var n_fattura               = $(this).find("td:eq(1) input").val();
            var emittente_fattura       = $(this).find("td:eq(2) input").val();
            var importo_imponibile      = $(this).find("td:eq(3) input").val();
            var importo_imponibile_iva  = $(this).find("td:eq(4) input").val();
            var fattura                 = file_names.fattura[index];
            var ricevuta_bonifico       = file_names.ricevuta_bonifico[index];

            var riga_saldo = righe_sal_saldo.eq(index);
            var sal_saldo              = riga_saldo.find("td:eq(1) p").text().trim();
            var relazione_finale       = riga_saldo.find("td:eq(2) input").attr('type') === 'file' ? file_names.saldo_relazione[index] : insertAndShift(riga_saldo, file_names.saldo_relazione, 2, index, riga_saldo.find("td:eq(2) p").text().trim());
            var sal                    = riga_saldo.find("td:eq(3) input").attr('type') === 'file' ? file_names.sal[index] : insertAndShift(riga_saldo, file_names.sal, 3, index, riga_saldo.find("td:eq(3) p").text().trim());
            var certificato_pagamento  = riga_saldo.find("td:eq(4) input").attr('type') === 'file' ? file_names.sal_certificato[index] : insertAndShift(riga_saldo, file_names.sal_certificato, 4, index, riga_saldo.find("td:eq(4) p").text().trim());

            righe_spese.push({
                tab1: [
                    categoria, 
                    n_fattura, 
                    emittente_fattura, 
                    importo_imponibile, 
                    importo_imponibile_iva,
                    fattura,
                    ricevuta_bonifico,
                    sal_saldo,
                    relazione_finale,
                    sal,
                    certificato_pagamento,
                    ""
                ]
            });
        }

        if (id == "totale_spdi") {
            var importo_imponibile_totale = $("#importo_imponibile_totale").attr("valore");
            var importo_imponibile_iva_totale = $("#importo_imponibile_iva_totale").attr("valore");

            righe_spese.push({
                tab1: [
                    "Totale",
                    "",
                    "",
                    importo_imponibile_totale, 
                    importo_imponibile_iva_totale,
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    ""
                ]
            });
        }
    });

    const checklist_data = righe_spese.map(riga => riga.tab1);

    checklist_data.forEach(el => {
        const row = sheet2.addRow(el);
        row.height = 52;
        row.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
        if (el[0] === "Totale") {
            row.getCell(1).font = { bold: true };
        }
    });

    sheet2.eachRow((row) => {
        row.eachCell((cell) => {
            cell.border = {
                top: { style: 'thin' },
                left: { style: 'thin' },
                bottom: { style: 'thin' },
                right: { style: 'thin' }
            };
        });
    });


    /* Terzo worksheet */

    sheet3.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });

    if (tipo_cantierabilita === "necessita") {
        sheet3.columns = [
            { key: 'tit_ab', width: 50 },
            { key: 'doc', width: 20},
            { key: 'note', width: 10 },
        ];
    } else if (tipo_cantierabilita === "necessita-forse") {
        sheet3.columns = [
            { key: 'tit_ab', width: 30 },
            { key: 'richiesto', width: 12 },
            { key: 'rilasciato', width: 12 },
            { key: 'doc_rich', width: 20 },
            { key: 'doc_ril', width: 20 },
            { key: 'note', width: 10 },
        ];
    }
    

    sheet3.mergeCells('A1:G4');
    sheet3.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet3.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet3.getCell('A1').font = { bold: true, size: 14 };
    sheet3.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet3.mergeCells('A5:G8');
    sheet3.getCell('A5').value = 'VERBALE ISTRUTTORIA LIQUIDAZIONE';
    sheet3.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet3.getCell('A5').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet3.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

    sheet3.mergeCells('A9:G13');
    sheet3.getCell('A9').value = $('input[name="acquisizione-pareri"]:checked').closest('.form-check').find('label').text().trim();
    sheet3.getCell('A9').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet3.getCell('A9').font = { bold: true, size: 14 };
    sheet3.getCell('A9').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'fcfc6a' } };

    if (tipo_cantierabilita === "necessita") {
        sheet3.addRow([
            "TITOLO ABILITATIVO",
            "DOCUMENTO",
            "NOTE"
        ]);
    } else if (tipo_cantierabilita === "necessita-forse") {
        sheet3.addRow([
            "TITOLO ABILITATIVO",
            "RICHIESTO",
            "RILASCIATO",
            "DOCUMENTO RICHIESTO",
            "DOCUMENTO RILASCIATO",
            "NOTE"
        ]);
    }

    var headerRow = sheet3.getRow(sheet3.rowCount);
    headerRow.height = 42;
    headerRow.eachCell((cell, colNumber) => {
        cell.alignment = { 
            horizontal: 'center', 
            vertical: 'middle',
            wrapText: true
        };
        cell.font = { bold: true };
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
        sheet3.getColumn(colNumber).width = sheet3.columns[colNumber - 1].width;
    });
    headerRow.commit();

    function is_file(input) {
        const type = input.attr('type');
        if (type === 'text') {
            return false;
        } else if (type === 'file') {
            return true;
        }
        return false;
    }
    
    const righe_cantierabilita = [];
    if (tipo_cantierabilita === "necessita") {
        const nomi_titoli = $('[id^="enti_preposti_input"]');
        let access_index = 0;
        nomi_titoli.each(function(index) {
            const nome_titolo = $(this);
            const idBase = nome_titolo.attr("id").replace("input", "file");
            const inputFile = $(`#${idBase}`);
            const isFile = is_file(inputFile);

            const doc = isFile
            ? (file_names.enti_preposti_file[access_index] ? file_names.enti_preposti_file[access_index++] : null)
            : inputFile.val();

            if (doc) {
                righe_cantierabilita.push({
                    tab1: [
                        nome_titolo.val(),
                        doc,
                        ""
                    ]
                });
            }
        });
    } else if (tipo_cantierabilita === "necessita-forse") {
        const righe_tabella = $(".tabella-testi tbody tr");
        let access_index_1 = 0;
        let access_index_2 = 0;
        righe_tabella.each(function(index) {
            const id = $(this).attr("id");

            if (id.startsWith("titoli_")) {
                const nome_titolo             = $(this).find("td:eq(0) input").val();
                const richiesto               = $(this).find("td:eq(1) select option:selected").text();
                const rilasciato              = $(this).find("td:eq(2) select option:selected").text();
                const inputFile1              = $(this).find("td:eq(3) input");
                const inputFile2              = $(this).find("td:eq(4) input");
                const isFile1 = is_file(inputFile1);
                const isFile2 = is_file(inputFile2);

                const doc_rich = isFile1
                ? (file_names.documento_abilitativo_richiesto[access_index_1] ? file_names.documento_abilitativo_richiesto[access_index_1++] : null)
                : inputFile1.val();
                const doc_ril = isFile2
                ? (file_names.documento_abilitativo_rilasciato[access_index_2] ? file_names.documento_abilitativo_rilasciato[access_index_2++] : null)
                : inputFile2.val();

                if (doc_rich && doc_ril) {
                    righe_cantierabilita.push({
                        tab1: [
                            nome_titolo,
                            richiesto,
                            rilasciato,
                            doc_rich,
                            doc_ril,
                            ""
                        ]
                    });
                }
            }
        });
    }


    const cantierabilita_data = righe_cantierabilita.map(riga => riga.tab1);

    cantierabilita_data.forEach(el => {
        const row = sheet3.addRow(el);
        row.height = 52;
        row.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    });

    sheet3.eachRow((row) => {
        row.eachCell((cell) => {
            cell.border = {
                top: { style: 'thin' },
                left: { style: 'thin' },
                bottom: { style: 'thin' },
                right: { style: 'thin' }
            };
        });
    });
    const buffer = await workbook.xlsx.writeBuffer();
    const fileBlob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
    saveAs(fileBlob, outputPath);
}